package com.ejie.ab04b.service.eventos;

import javax.jms.Message;

/**
 * Servicio para el tratamiento programatico del destino de error final para
 * mensajes que han caducado, alcanzado su limite de nueva entrega, o no se
 * quieren reintentar Implementacion mediante el aplicativo de la posible
 * configuracion de un destino de error en las colas del servidor
 * 
 * @author GFI(SGG)
 * 
 */
public interface DeadMessageService {
	
	/**
	 * Tratamiento para un mensaje que no se debe reintentar
	 * 
	 *  origen
	 *            Origen del evento puede ser uno de los valores de constantes
	 *            <ul>
	 *            <li>Constantes.EVENTO_FRONT</li>
	 *            <li>Constantes.EVENTO_AVISOS</li>
	 *            <li>Constantes.EVENTO_DOCUMENTACION</li>
	 *            <li>...</li>
	 *            </ul>
	 *  message
	 *            mensaje a tratar
	 *  true si el tratamiento del mensaje se ha podido finalizar, false
	 *         en caso contrario
	 *
	 * @param origen the origen
	 * @param message the message
	 * @return true, if successful
	 */
	boolean tratarDeadMessage(String origen, Message message);

}
